/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TaskQueue {
    private static Map<String, Runnable> lookupMap = new HashMap<String, Runnable>();
    Queue<Runnable> taskQueue = new ConcurrentLinkedQueue<Runnable>();
    ThreadGroup threadPool;

    public TaskQueue(String name, int number) {
        String poolName = name == null || name.equals("") ? "Application ThreadPool" : name;
        int threadNumber = number < 1 ? 1 : number;
        this.threadPool = new ThreadGroup(poolName);
        for (int i = 0; i < threadNumber; ++i) {
            new PoolWorker(this.threadPool, i).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable task) {
        Queue<Runnable> queue = this.taskQueue;
        synchronized (queue) {
            this.taskQueue.offer(task);
            this.taskQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskOnce(final String id, final long delay, final Runnable task) {
        if (task == null) {
            return;
        }
        Map<String, Runnable> map = lookupMap;
        synchronized (map) {
            lookupMap.put(id, task);
        }
        new Thread("Add \"" + id + "\" task once."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (delay > 0L) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                Map map = lookupMap;
                synchronized (map) {
                    if (lookupMap.get(id) == task) {
                        Queue<Runnable> queue = TaskQueue.this.taskQueue;
                        synchronized (queue) {
                            TaskQueue.this.taskQueue.offer(task);
                            TaskQueue.this.taskQueue.notify();
                        }
                    } else {
                        return;
                    }
                }
            }
        }.start();
    }

    public void removeAllTasks() {
        while (this.taskQueue.poll() != null) {
        }
    }

    public void interruptRunning() {
        this.threadPool.interrupt();
    }

    class PoolWorker
    extends Thread {
        public PoolWorker(ThreadGroup pool, int id) {
            super(pool, null, pool.getName() + " - Worker #" + id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Queue<Runnable> queue = TaskQueue.this.taskQueue;
                synchronized (queue) {
                    while (TaskQueue.this.taskQueue.isEmpty()) {
                        try {
                            TaskQueue.this.taskQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                Runnable task = TaskQueue.this.taskQueue.poll();
                try {
                    if (task != null) {
                        task.run();
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                PoolWorker.interrupted();
            }
        }
    }
}

