/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.cmdline;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CmdLineString
extends CmdLineOption {
    private final List<String> values = new ArrayList<String>();
    private final List<String> allowed;

    public CmdLineString(String longName, String description) {
        this(longName, description, null);
    }

    public CmdLineString(String longName, String description, String[] valid) {
        super(longName, '-', description);
        this.allowed = valid != null && valid.length > 0 ? Arrays.asList(valid) : new ArrayList<String>();
    }

    @Override
    public String getLongSyntax() {
        if (!this.hasLongName() || this.visibility == CmdLineOption.Visibility.HIDDEN) {
            return "";
        }
        String syntax = "--" + this.longName + "=";
        if (this.allowed.size() == 0) {
            syntax = syntax + "VALUE";
        } else {
            syntax = syntax + this.allowed.get(0);
            for (int i = 1; i < this.allowed.size(); ++i) {
                syntax = syntax + "|" + this.allowed.get(i);
            }
        }
        return syntax;
    }

    @Override
    public boolean parse(String argument) {
        String data;
        if (!argument.startsWith(this.longName)) {
            return false;
        }
        if (this.longName.equals(argument)) {
            data = "";
        } else {
            String param = argument.substring(this.longName.length());
            if (!param.startsWith("=")) {
                throw new CmdLineException("Missing the '=' character between the \"--" + this.longName + "\" option and the value part \"" + argument.substring(this.longName.length()) + "\".");
            }
            data = param.substring("=".length());
        }
        if (this.allowed.size() > 0) {
            boolean valid = false;
            for (String s : this.allowed) {
                if (!data.equalsIgnoreCase(s)) continue;
                valid = true;
            }
            if (!valid) {
                throw new CmdLineException("The string '" + data + "' is not allowed as value for the \"" + "--" + this.longName + "\" option. Please use a value from the following list instead: " + this.allowed.toString());
            }
        }
        this.values.add(data);
        return true;
    }

    @Override
    public boolean parse(char argument) {
        return false;
    }

    public String getValue() {
        return this.getValue(0);
    }

    public String getValue(int index) {
        if (!this.parser.isAlreadyParsed()) {
            this.parser.parse();
        }
        return this.values.get(index);
    }

    public String[] getValues() {
        if (!this.parser.isAlreadyParsed()) {
            this.parser.parse();
        }
        return this.values.toArray(new String[0]);
    }
}

