/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.cmdline;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineException;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.string.PrintStreamFormatter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class CmdLineParser {
    protected static final char SHORT_OPTION_MARKER = '-';
    protected static final String LONG_OPTION_MARKER = "--";
    protected static final String VALUE_MARKER = "=";
    private final List<String> argumentList;
    private boolean alreadyParsed;
    private final SortedSet<CmdLineOption> knownOptions;
    private final List<String> nonOptionArgs;
    private String programName;
    private String programDescription;
    private String programArguments;
    private String programRelease;
    private String programLicense;
    private String programCopyright;

    public CmdLineParser(String[] args) {
        this.argumentList = new ArrayList<String>(args.length);
        this.knownOptions = new TreeSet<CmdLineOption>();
        this.nonOptionArgs = new ArrayList<String>();
        Collections.addAll(this.argumentList, args);
        this.alreadyParsed = false;
        this.setProgramName("");
        this.setProgramArguments("");
        this.setProgramDescription("");
        this.setReleaseInfo("");
        this.setLicenseInfo("");
        this.setCopyrightInfo("");
    }

    public CmdLineParser(String[] args, String name, String release) {
        this.argumentList = new ArrayList<String>(args.length);
        this.knownOptions = new TreeSet<CmdLineOption>();
        this.nonOptionArgs = new ArrayList<String>();
        Collections.addAll(this.argumentList, args);
        this.alreadyParsed = false;
        this.setProgramName(name);
        this.setProgramArguments("");
        this.setProgramDescription("");
        this.setReleaseInfo(release);
        this.setLicenseInfo("");
        this.setCopyrightInfo("");
    }

    public void setLicenseInfo(String license) {
        this.programLicense = license == null ? "" : license;
    }

    public void setCopyrightInfo(String copyright) {
        this.programCopyright = copyright == null ? "" : copyright;
    }

    public void setProgramName(String program) {
        this.programName = program == null ? "" : program;
    }

    public void setProgramArguments(String argumentInfo) {
        this.programArguments = argumentInfo == null ? "" : argumentInfo;
    }

    public void setProgramDescription(String description) {
        this.programDescription = description == null ? "" : description;
    }

    public void setReleaseInfo(String release) {
        if (release != null) {
            this.programRelease = release;
        }
    }

    public void setReleaseInfo(String pkgName, String pkgRelease) {
        StringBuilder temp = new StringBuilder();
        if (pkgName != null) {
            temp.append(pkgName);
        }
        if (pkgRelease != null) {
            temp.append("-").append(pkgRelease);
        }
        this.programRelease = temp.toString();
    }

    public String getReleaseInfo() {
        assert (this.programRelease != null) : "The release information must not be 'null'!";
        return this.programRelease;
    }

    public void printReleaseInfo(PrintStream prt) {
        if (this.programName.length() > 0 && this.programRelease.length() > 0) {
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 2, this.programName + "   Release: " + this.programRelease);
        } else if (this.programName.length() > 0) {
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 2, this.programName);
        } else if (this.programRelease.length() > 0) {
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 2, "Release " + this.programRelease);
        }
        if (this.programCopyright.length() > 0) {
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 2, this.programCopyright);
        }
        if (this.programLicense.length() > 0) {
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 2, this.programLicense);
        }
        PrintStreamFormatter.printWrapped(prt);
    }

    public void printOnlineHelp(PrintStream prt) {
        if (this.programName.length() > 0 && this.programDescription.length() > 0) {
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 2, "Name:");
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 4, this.programName + " -- " + this.programDescription);
        }
        if (this.programName.length() > 0) {
            String syntax = this.knownOptions.size() > 0 ? this.programName + "  [OPTIONS]  " + this.programArguments : this.programName + this.programArguments;
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 2, "Usage:");
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 4, syntax.trim());
        }
        if (this.knownOptions.size() > 0) {
            PrintStreamFormatter.printWrapped(prt);
            PrintStreamFormatter.printWrapped(prt, 2, "Options:");
            PrintStreamFormatter.printWrapped(prt);
            for (CmdLineOption option : this.knownOptions) {
                if (option.visibility == CmdLineOption.Visibility.HIDDEN) continue;
                if (option.hasShortName() && option.hasLongName()) {
                    PrintStreamFormatter.printWrapped(prt, 4, option.getShortSyntax() + ", " + option.getLongSyntax());
                } else if (option.hasShortName()) {
                    PrintStreamFormatter.printWrapped(prt, 4, option.getShortSyntax());
                } else if (option.hasLongName()) {
                    PrintStreamFormatter.printWrapped(prt, 4, option.getLongSyntax());
                }
                PrintStreamFormatter.printWrapped(prt, 8, option.getDescription());
                PrintStreamFormatter.printWrapped(prt);
            }
            PrintStreamFormatter.printWrapped(prt, 2, "For further and more detailed information about this program please see the manual.");
            PrintStreamFormatter.printWrapped(prt);
        }
    }

    public CmdLineOption registerOption(CmdLineOption option) {
        int defaultSortIndex = 100 + (this.knownOptions.size() + 1) * 10;
        return this.registerOption(option, defaultSortIndex);
    }

    public CmdLineOption registerOption(CmdLineOption option, int index) {
        if (this.alreadyParsed) {
            throw new CmdLineException("You cannot add more command line options after the command line was already parsed.");
        }
        if (option == null) {
            throw new CmdLineException("A 'null' command line option does not make any sense.");
        }
        option.registerParser(this);
        option.setSortIndex(index);
        if (!this.knownOptions.add(option)) {
            throw new CmdLineException("The command line option is already in the list of know options.");
        }
        return option;
    }

    public boolean isAlreadyParsed() {
        return this.alreadyParsed;
    }

    protected void parse() throws CmdLineException {
        if (this.isAlreadyParsed()) {
            return;
        }
        for (String arg : this.argumentList) {
            if (arg.startsWith(LONG_OPTION_MARKER)) {
                String stripped = arg.substring(LONG_OPTION_MARKER.length());
                boolean processed = false;
                for (CmdLineOption option : this.knownOptions) {
                    if (!option.parse(stripped)) continue;
                    processed = true;
                    ++option.matchCount;
                    break;
                }
                if (processed) continue;
                throw new CmdLineException("Unknown command line option '" + arg + "'!  Try option '--help' for a short description of all available options.");
            }
            if (arg.charAt(0) == '-') {
                for (int offset = 1; offset < arg.length(); ++offset) {
                    char tag = arg.charAt(offset);
                    boolean processed = false;
                    for (CmdLineOption option : this.knownOptions) {
                        if (!option.parse(tag)) continue;
                        processed = true;
                        ++option.matchCount;
                        break;
                    }
                    if (processed) continue;
                    throw new CmdLineException("Unknown command line option '-" + tag + "' found in '" + arg + "'!  Try option '-h' for a short description of all available options.");
                }
                continue;
            }
            this.nonOptionArgs.add(arg);
        }
        block7: for (CmdLineOption option : this.knownOptions) {
            switch (option.multiplicity) {
                case ZERO_OR_ONCE: {
                    if (option.matchCount == 0 || option.matchCount == 1) continue block7;
                    throw new CmdLineException("The optional command line argument '--" + option.longName + "' may only be given once. (But the command line contained it " + option.matchCount + " times)");
                }
            }
            if (option.matchCount >= 0) continue;
            throw new CmdLineException("Internal command line parser error! Command line parameter '--" + option.longName + "' was found incredible " + option.matchCount + " times. What is going on here ???");
        }
        this.alreadyParsed = true;
    }

    public List<String> getArgumentList() {
        if (!this.isAlreadyParsed()) {
            this.parse();
        }
        return this.nonOptionArgs;
    }
}

