/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.cmdline;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineParser;

public abstract class CmdLineOption
implements Comparable<CmdLineOption> {
    protected final String longName;
    protected final char shortName;
    protected final String description;
    protected Visibility visibility;
    protected Occurrence multiplicity;
    protected int matchCount;
    protected int sortIndex;
    protected CmdLineParser parser;

    protected CmdLineOption(String optionLongName, char optionShortName, String optionDescription) {
        this.longName = optionLongName;
        this.shortName = optionShortName;
        this.description = optionDescription;
        this.visibility = Visibility.VISIBLE;
        this.multiplicity = Occurrence.ZERO_OR_ONCE;
        this.parser = null;
        this.sortIndex = 0;
        this.matchCount = 0;
    }

    public CmdLineOption set(Occurrence multiplicity) {
        this.multiplicity = multiplicity;
        return this;
    }

    public CmdLineOption set(Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public boolean isMatched() {
        if (!this.parser.isAlreadyParsed()) {
            this.parser.parse();
        }
        return this.matchCount > 0;
    }

    public int matchCount() {
        if (!this.parser.isAlreadyParsed()) {
            this.parser.parse();
        }
        return this.matchCount;
    }

    void registerParser(CmdLineParser parser) {
        this.parser = parser;
    }

    void setSortIndex(int index) {
        this.sortIndex = index;
    }

    public boolean hasShortName() {
        return this.shortName != '-';
    }

    public boolean hasLongName() {
        return !this.longName.startsWith("=");
    }

    public String getShortSyntax() {
        if (this.hasShortName() && this.visibility == Visibility.VISIBLE) {
            return "-" + this.shortName;
        }
        return "";
    }

    public String getLongSyntax() {
        if (this.hasLongName() && this.visibility == Visibility.VISIBLE) {
            return "--" + this.longName;
        }
        return "";
    }

    public String getDescription() {
        if (this.visibility == Visibility.VISIBLE) {
            return this.description;
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CmdLineOption)) {
            return false;
        }
        CmdLineOption other = (CmdLineOption)obj;
        return this.longName.equals(other.longName);
    }

    public int hashCode() {
        return this.longName.hashCode();
    }

    @Override
    public int compareTo(CmdLineOption other) {
        if (other == null) {
            throw new NullPointerException();
        }
        long diff = this.sortIndex - other.sortIndex;
        if (diff > 0L) {
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return this.longName.compareTo(other.longName);
    }

    public abstract boolean parse(String var1);

    public abstract boolean parse(char var1);

    public static enum Visibility {
        HIDDEN,
        VISIBLE;

    }

    public static enum Occurrence {
        ZERO_OR_ONCE,
        ZERO_OR_MORE,
        EXACTLY_ONCE,
        ONCE_OR_MORE;

    }
}

