/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.cmdline;

import de.gfz_potsdam.gipp.common.cmdline.CmdLineBoolean;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineOption;
import de.gfz_potsdam.gipp.common.cmdline.CmdLineParser;
import de.gfz_potsdam.gipp.common.cmdline.LogVerboseFormatter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CmdLineApplication {
    protected CmdLineParser cmdLineParser;
    protected Logger log;
    protected final CmdLineBoolean debugOption = new CmdLineBoolean("debug", "Become extremely chatty.)");
    protected final CmdLineBoolean verboseOption = new CmdLineBoolean("verbose", 'v', "Output basic diagnostic information and report on progress.");
    protected final CmdLineBoolean helpOption = new CmdLineBoolean("help", 'h', "Output this help and exit the program.");
    protected final CmdLineBoolean versionOption = new CmdLineBoolean("version", "Output version information and exit.");

    protected void logThrowable(Throwable exp) {
        String problem = exp.getClass().getSimpleName();
        String details = exp.getMessage();
        if (details != null && details.length() > 0) {
            this.log.severe("Detected a \"" + problem + "\"");
            this.log.severe("  " + details);
        } else {
            this.log.severe("Detected a \"" + problem + "\"");
        }
        if (this.log.getLevel().intValue() <= Level.FINEST.intValue()) {
            this.log.severe("");
            this.log.severe("--- begin of stack trace ---");
            for (StackTraceElement element : exp.getStackTrace()) {
                StringBuilder line = new StringBuilder();
                line.append(element.getClassName()).append(".");
                line.append(element.getMethodName()).append(" (");
                if (element.isNativeMethod()) {
                    line.append("Native Method");
                } else if (element.getFileName() != null && element.getLineNumber() >= 0) {
                    line.append(element.getFileName()).append(":").append(element.getLineNumber());
                } else {
                    line.append("Unknown Source");
                }
                line.append(")");
                this.log.severe(line.toString());
            }
            this.log.severe("--- end of stack trace ---");
            this.log.severe("");
        }
    }

    protected void handleCommonOptions() {
        if (this.debugOption.isMatched()) {
            this.log.setLevel(Level.FINEST);
            this.log.fine("Running with DEBUG mode enabled.");
        }
        if (this.versionOption.isMatched()) {
            this.cmdLineParser.printReleaseInfo(System.out);
            System.exit(0);
        }
        if (this.helpOption.isMatched()) {
            this.cmdLineParser.printOnlineHelp(System.out);
            System.exit(0);
        }
        if (this.verboseOption.isMatched() && !this.debugOption.isMatched()) {
            this.log.setLevel(Level.INFO);
            this.log.fine("Enable verbose user feedback.");
        }
    }

    protected CmdLineApplication(String[] cmdLineArgs) {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new LogVerboseFormatter());
        handler.setLevel(Level.ALL);
        this.log = Logger.getLogger("de.gfz_potsdam.gipp");
        this.log.setUseParentHandlers(false);
        this.log.addHandler(handler);
        this.log.setLevel(Level.WARNING);
        this.cmdLineParser = new CmdLineParser(cmdLineArgs);
        this.cmdLineParser.registerOption(this.helpOption, 20);
        this.cmdLineParser.registerOption(this.versionOption, 30);
        this.cmdLineParser.registerOption(this.debugOption, 70).set(CmdLineOption.Visibility.HIDDEN);
        this.cmdLineParser.registerOption(this.verboseOption, 80);
    }
}

