/*
 * Decompiled with CFR 0.152.
 */
package de.gfz_potsdam.gipp.common.array;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static int[] concatArrays(int[] ... sourceArrays) {
        int total = 0;
        int count = 0;
        if (sourceArrays == null) {
            return null;
        }
        for (int[] array : sourceArrays) {
            if (array == null) continue;
            if (array.length > Integer.MAX_VALUE - total) {
                throw new ArithmeticException("Integer overflow while summing array sizes.");
            }
            total += array.length;
        }
        int[] targetArray = new int[total];
        for (int[] array : sourceArrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, targetArray, count, array.length);
            count += array.length;
        }
        return targetArray;
    }

    public static double[] concatArrays(double[] ... sourceArrays) {
        int total = 0;
        int count = 0;
        if (sourceArrays == null) {
            return null;
        }
        for (double[] array : sourceArrays) {
            if (array == null) continue;
            if (array.length > Integer.MAX_VALUE - total) {
                throw new ArithmeticException("Integer overflow while summing array sizes.");
            }
            total += array.length;
        }
        double[] targetArray = new double[total];
        for (double[] array : sourceArrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, targetArray, count, array.length);
            count += array.length;
        }
        return targetArray;
    }

    public static byte[] copySubArray(byte[] src, int srcPos, int length) {
        assert (length >= 0) : "Length of requested sub-array must be positive.";
        byte[] newArray = new byte[length];
        System.arraycopy(src, srcPos, newArray, 0, Math.min(src.length - srcPos, length));
        return newArray;
    }

    public static int[] copySubArray(int[] src, int srcPos, int length) {
        assert (length >= 0) : "Length of requested sub-array must be positive.";
        int[] newArray = new int[length];
        System.arraycopy(src, srcPos, newArray, 0, Math.min(src.length - srcPos, length));
        return newArray;
    }

    public static double[] copySubArray(double[] src, int srcPos, int length) {
        assert (length >= 0) : "Length of requested sub-array must be positive.";
        double[] newArray = new double[length];
        System.arraycopy(src, srcPos, newArray, 0, Math.min(src.length - srcPos, length));
        return newArray;
    }
}

